/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9282;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import zabi.minecraft.extraalchemy.client.tooltip.StatusEffectContainer;
import zabi.minecraft.extraalchemy.items.ModComponents;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.screen.potion_bag.BagInventory;
import zabi.minecraft.extraalchemy.screen.potion_bag.PotionBagScreenhandlerFactory;
import zabi.minecraft.extraalchemy.utils.CodecUtil;
import zabi.minecraft.extraalchemy.utils.LibMod;
import zabi.minecraft.extraalchemy.utils.Log;
import zabi.minecraft.extraalchemy.utils.PotionUtilities;

public class PotionBagItem
extends class_1792
implements StatusEffectContainer {
    private static final class_6862<class_1792> TAG_POTION = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)LibMod.id("potion_for_bag"));

    public PotionBagItem() {
        super(new class_1792.class_1793().method_7889(1).method_57349(class_9334.field_49651, (Object)class_1844.field_49274).method_57349(ModComponents.SELECTION_MODE, (Object)SelectionMode.DESELECT).method_57349(class_9334.field_49622, (Object)class_9288.method_57493((List)class_2371.method_10213((int)18, (Object)class_1799.field_8037))));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        class_1844 selectedPotion = (class_1844)stack.method_57824(class_9334.field_49651);
        if (selectedPotion.method_57405() && selectedPotion.comp_2378().isPresent()) {
            int avail = this.getSelectedPotionAmount(stack).get();
            class_5250 potion_text = class_2561.method_43471((String)class_1842.method_8051((Optional)selectedPotion.comp_2378(), (String)"")).method_27695(new class_124[]{class_124.field_1064, class_124.field_1067});
            class_5250 amount_text = class_2561.method_43470((String)("" + avail)).method_27692(class_124.field_1078);
            tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_bag.selected.potion", (Object[])new Object[]{potion_text, amount_text}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.extraalchemy.potion_bag.selected.none").method_27692(class_124.field_1079));
        }
        class_5250 option = class_2561.method_43471((String)("item.extraalchemy.potion_bag.autoselect.option." + this.getSelectionMode(stack).toString().toLowerCase())).method_27692(class_124.field_1065);
        tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_bag.autoselect", (Object[])new Object[]{option}));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_bag.autoselect.change", (Object[])new Object[]{class_2561.method_43472((String)"key.extraalchemy.potion_bag_mode").method_27692(class_124.field_1075)}));
        if (selectedPotion.method_57405() && selectedPotion.comp_2378().isPresent()) {
            selectedPotion.method_47372(tooltip::add, 1.0f, context.method_59531());
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            if (user.method_5715()) {
                PotionBagScreenhandlerFactory factory = new PotionBagScreenhandlerFactory(stack, hand);
                user.method_17355((class_3908)factory);
            } else {
                this.handleRefill(stack);
                class_1844 selectedPotion = (class_1844)stack.method_57824(class_9334.field_49651);
                Optional<Integer> optPotAmount = this.getSelectedPotionAmount(stack);
                if (optPotAmount.isPresent() && optPotAmount.get() > 0 && selectedPotion.method_57405() && selectedPotion.comp_2378().isPresent()) {
                    user.method_6019(hand);
                }
                user.method_31548().method_5431();
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    private void handleRefill(class_1799 stack) {
        Optional<Integer> optPotAmount = this.getSelectedPotionAmount(stack);
        if (optPotAmount.isEmpty() || optPotAmount.get() == 0) {
            switch (this.getSelectionMode(stack).ordinal()) {
                case 2: {
                    PotionBagItem.selectPotion(stack, null);
                    break;
                }
                case 1: {
                    this.getFirstAvailablePotion(stack).ifPresent(potionStack -> PotionBagItem.selectPotion(stack, potionStack));
                    break;
                }
            }
        }
    }

    public static void selectPotion(class_1799 bag, class_1799 potionStack) {
        if (potionStack == null) {
            bag.method_57379(class_9334.field_49651, (Object)class_1844.field_49274);
            return;
        }
        class_1844 pcc = (class_1844)potionStack.method_57824(class_9334.field_49651);
        if (pcc == null) {
            bag.method_57379(class_9334.field_49651, (Object)class_1844.field_49274);
            return;
        }
        bag.method_57379(class_9334.field_49651, (Object)((class_1844)potionStack.method_57824(class_9334.field_49651)));
    }

    public class_1799 method_7861(class_1799 bag, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657) {
            class_1844 selectedPotion = (class_1844)bag.method_57824(class_9334.field_49651);
            if (selectedPotion.method_57405() && selectedPotion.comp_2378().isPresent()) {
                BagInventory inv = new BagInventory(bag, user.method_6058());
                this.findPotionAndApply(user, selectedPotion, inv);
            }
            ((class_1657)user).method_7357().method_7906((class_1792)this, 20);
        }
        return super.method_7861(bag, world, user);
    }

    private void findPotionAndApply(class_1309 user, class_1844 target, BagInventory inv) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 currentStack = inv.method_5438(i);
            class_1844 currentPotion = (class_1844)currentStack.method_57824(class_9334.field_49651);
            if (!currentPotion.comp_2378().isPresent() || !target.method_57401((class_6880)currentPotion.comp_2378().get())) continue;
            currentStack.method_7909().method_7861(currentStack, user.method_5770(), user);
            break;
        }
        inv.method_5432((class_1657)user);
        class_1661 pinv = ((class_1657)user).method_31548();
        pinv.method_5431();
    }

    public static boolean isValidPotionItem(class_1799 stack) {
        if (stack.method_31573(TAG_POTION)) {
            return PotionUtilities.hasPotionEffects(stack);
        }
        return false;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 20;
    }

    public boolean method_7886(class_1799 stack) {
        return this.getSelectedPotion(stack).isPresent();
    }

    public Optional<class_1844> getSelectedPotion(class_1799 bag) {
        class_1844 selectedPotion = (class_1844)bag.method_57824(class_9334.field_49651);
        if (!selectedPotion.method_57405() || selectedPotion.comp_2378().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(selectedPotion);
    }

    public Optional<Integer> getSelectedPotionAmount(class_1799 bag) {
        int count = 0;
        Optional<class_1844> potopt = this.getSelectedPotion(bag);
        if (potopt.isPresent()) {
            class_1844 target = potopt.get();
            BagInventory inv = new BagInventory(bag, null);
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1844 currentPotion = (class_1844)inv.method_5438(i).method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
                if (!currentPotion.comp_2378().isPresent() || !target.method_57401((class_6880)currentPotion.comp_2378().get())) continue;
                ++count;
            }
            return Optional.of(count);
        }
        return Optional.empty();
    }

    private SelectionMode getSelectionMode(class_1799 stack) {
        SelectionMode mode = SelectionMode.HOLD;
        if (stack.method_57826(ModComponents.SELECTION_MODE)) {
            mode = (SelectionMode)((Object)stack.method_57825(ModComponents.SELECTION_MODE, (Object)SelectionMode.HOLD));
        }
        return mode;
    }

    public static void toggleStatusForPlayer(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == ModItems.POTION_BAG) {
            SelectionMode currentMode = (SelectionMode)((Object)stack.method_57824(ModComponents.SELECTION_MODE));
            stack.method_57379(ModComponents.SELECTION_MODE, (Object)currentMode.next());
            player.method_31548().method_5431();
        } else {
            Log.w("Not holding a bag");
        }
    }

    public Optional<class_1799> getFirstAvailablePotion(class_1799 stack) {
        BagInventory inv = new BagInventory(stack, null);
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 currentStack = inv.method_5438(i);
            class_1844 currentPotion = (class_1844)currentStack.method_57824(class_9334.field_49651);
            if (currentPotion == null || !currentPotion.method_57405() || !currentPotion.comp_2378().isPresent()) continue;
            return Optional.of(currentStack.method_7972());
        }
        return Optional.empty();
    }

    public static int getColor(class_1799 stack, int index) {
        if (index > 0) {
            return -1;
        }
        return class_9282.method_57470((class_1799)stack, (int)13530912) | 0xFF000000;
    }

    @Override
    public List<class_1293> getContainedEffects(class_1799 stack) {
        return PotionUtilities.getEffects(stack);
    }

    @Override
    public boolean hasEffects(class_1799 stack) {
        return this.getSelectedPotion(stack).isPresent() && StatusEffectContainer.super.hasEffects(stack);
    }

    public static enum SelectionMode {
        HOLD,
        NEXT,
        DESELECT;

        public static final Codec<SelectionMode> CODEC;

        public SelectionMode next() {
            SelectionMode[] modes = SelectionMode.values();
            int nextIndex = (this.ordinal() + 1) % modes.length;
            return modes[nextIndex];
        }

        static {
            CODEC = CodecUtil.enumCodec(SelectionMode.class);
        }
    }
}

